/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.ingredients.fluid;

import com.google.common.base.MoreObjects;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;
import mezz.jei.api.helpers.IColorHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.IIngredientTypeWithSubtypes;
import mezz.jei.api.ingredients.subtypes.ISubtypeManager;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.common.platform.IPlatformFluidHelperInternal;
import mezz.jei.common.platform.IPlatformRegistry;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.TagUtil;
import net.minecraft.class_1058;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2348;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class FluidIngredientHelper<T>
implements IIngredientHelper<T> {
    private final ISubtypeManager subtypeManager;
    private final IColorHelper colorHelper;
    private final IPlatformFluidHelperInternal<T> platformFluidHelper;
    private final IPlatformRegistry<class_3611> registry;
    private final IIngredientTypeWithSubtypes<class_3611, T> fluidType;

    public FluidIngredientHelper(ISubtypeManager subtypeManager, IColorHelper colorHelper, IPlatformFluidHelperInternal<T> platformFluidHelper) {
        this.subtypeManager = subtypeManager;
        this.colorHelper = colorHelper;
        this.platformFluidHelper = platformFluidHelper;
        this.registry = Services.PLATFORM.getRegistry(class_2378.field_25103);
        this.fluidType = platformFluidHelper.getFluidIngredientType();
    }

    @Override
    public IIngredientType<T> getIngredientType() {
        return this.platformFluidHelper.getFluidIngredientType();
    }

    @Override
    public String getDisplayName(T ingredient) {
        class_2561 displayName = this.platformFluidHelper.getDisplayName(ingredient);
        return displayName.getString();
    }

    @Override
    public String getUniqueId(T ingredient, UidContext context) {
        class_3611 fluid = this.fluidType.getBase(ingredient);
        class_2960 registryName = this.registry.getRegistryName(fluid);
        StringBuilder result = new StringBuilder().append("fluid:").append(registryName);
        String subtypeInfo = this.subtypeManager.getSubtypeInfo(this.fluidType, ingredient, context);
        if (!subtypeInfo.isEmpty()) {
            result.append(":");
            result.append(subtypeInfo);
        }
        return result.toString();
    }

    @Override
    public String getWildcardId(T ingredient) {
        class_3611 fluid = this.fluidType.getBase(ingredient);
        class_2960 registryName = this.registry.getRegistryName(fluid);
        return "fluid:" + registryName;
    }

    @Override
    public String getModId(T ingredient) {
        class_3611 fluid = this.fluidType.getBase(ingredient);
        class_2960 registryName = this.registry.getRegistryName(fluid);
        if (registryName == null) {
            String ingredientInfo = this.getErrorInfo(ingredient);
            throw new IllegalStateException("null registry name for: " + ingredientInfo);
        }
        return registryName.method_12836();
    }

    @Override
    public Iterable<Integer> getColors(T ingredient) {
        class_1058 fluidStillSprite = this.platformFluidHelper.getStillFluidSprite(ingredient);
        int renderColor = this.platformFluidHelper.getColorTint(ingredient);
        return this.colorHelper.getColors(fluidStillSprite, renderColor, 1);
    }

    @Override
    public String getResourceId(T ingredient) {
        class_3611 fluid = this.fluidType.getBase(ingredient);
        class_2960 registryName = this.registry.getRegistryName(fluid);
        if (registryName == null) {
            String ingredientInfo = this.getErrorInfo(ingredient);
            throw new IllegalStateException("null registry name for: " + ingredientInfo);
        }
        return registryName.method_12832();
    }

    @Override
    public class_2960 getResourceLocation(T ingredient) {
        class_3611 fluid = this.fluidType.getBase(ingredient);
        class_2960 registryName = this.registry.getRegistryName(fluid);
        if (registryName == null) {
            String ingredientInfo = this.getErrorInfo(ingredient);
            throw new IllegalStateException("null registry name for: " + ingredientInfo);
        }
        return registryName;
    }

    @Override
    public class_1799 getCheatItemStack(T ingredient) {
        class_3611 fluid = this.fluidType.getBase(ingredient);
        class_1792 filledBucket = fluid.method_15774();
        return new class_1799((class_1935)filledBucket);
    }

    @Override
    public T copyIngredient(T ingredient) {
        return this.platformFluidHelper.copy(ingredient);
    }

    @Override
    public T normalizeIngredient(T ingredient) {
        return this.platformFluidHelper.normalize(ingredient);
    }

    @Override
    public Collection<class_2960> getTags(T ingredient) {
        class_3611 fluid = this.fluidType.getBase(ingredient);
        Stream tagKeyStream = class_2378.field_11154.method_29113((Object)fluid).flatMap(arg_0 -> ((class_2348)class_2378.field_11154).method_40264(arg_0)).map(class_6880::method_40228).orElse(Stream.of(new class_6862[0]));
        return TagUtil.getTags(tagKeyStream);
    }

    @Override
    public String getErrorInfo(@Nullable T ingredient) {
        if (ingredient == null) {
            return "null";
        }
        MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper(ingredient.getClass());
        class_3611 fluid = this.fluidType.getBase(ingredient);
        if (fluid != null) {
            class_2561 displayName = this.platformFluidHelper.getDisplayName(ingredient);
            toStringHelper.add("Fluid", (Object)displayName.getString());
        } else {
            toStringHelper.add("Fluid", (Object)"null");
        }
        toStringHelper.add("Amount", this.platformFluidHelper.getAmount(ingredient));
        this.platformFluidHelper.getTag(ingredient).ifPresent(tag -> toStringHelper.add("Tag", tag));
        return toStringHelper.toString();
    }

    @Override
    public Optional<class_2960> getTagEquivalent(Collection<T> ingredients) {
        return TagUtil.getTagEquivalent(ingredients, this.fluidType::getBase, () -> ((class_2348)class_2378.field_11154).method_40272());
    }
}

